(window["webpackJsonpCoveoForSitecore"] = window["webpackJsonpCoveoForSitecore"] || []).push([["ValidateAnalyticsIncluded"],{

/***/ "./src/ui/analytics/ValidateAnalyticsIncluded.ts":
/*!*******************************************************!*\
  !*** ./src/ui/analytics/ValidateAnalyticsIncluded.ts ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var coveo_search_ui_1 = __webpack_require__(/*! coveo-search-ui */ "coveo-search-ui");
var ContextEvents_1 = __webpack_require__(/*! ../../events/ContextEvents */ "./src/events/ContextEvents.ts");
var defaultErrorMessage = "The Coveo Analytics are not enabled for this Search Interface. Insert a Coveo For Sitecore Analytics component to record Coveo Usage Analytics data.";
var ValidateAnalyticsIncluded = /** @class */ (function (_super) {
    __extends(ValidateAnalyticsIncluded, _super);
    function ValidateAnalyticsIncluded(element, options, bindings) {
        var _this = _super.call(this, element, ValidateAnalyticsIncluded.ID, bindings) || this;
        _this.element = element;
        _this.options = options;
        _this.bindings = bindings;
        _this.options = coveo_search_ui_1.ComponentOptions.initComponentOptions(element, ValidateAnalyticsIncluded, options);
        _this.bind.onRootElement(ContextEvents_1.SitecoreContextEvents.onSitecoreContextInitialization, _this.onSitecoreContextInitialization);
        return _this;
    }
    ValidateAnalyticsIncluded.prototype.onSitecoreContextInitialization = function (sitecoreContextArgs) {
        if (sitecoreContextArgs.shouldHaveAnalyticsComponent && this.searchInterfaceHasNoBoundAnalyticsComponent()) {
            console.warn(defaultErrorMessage);
            if (sitecoreContextArgs.isInExperienceEditor) {
                this.element.appendChild(this.createErrorMessageElement(defaultErrorMessage));
            }
        }
    };
    ValidateAnalyticsIncluded.prototype.searchInterfaceHasNoBoundAnalyticsComponent = function () {
        return this.searchInterface.getComponents("Analytics").length === 0 &&
            this.searchInterface.getComponents("ForSitecoreAnalytics").length === 0;
    };
    ValidateAnalyticsIncluded.prototype.createErrorMessageElement = function (errorMessage) {
        var errorSpan = document.createElement("span");
        errorSpan.classList.add("errorMessage");
        errorSpan.textContent = errorMessage;
        return errorSpan;
    };
    ValidateAnalyticsIncluded.ID = "ValidateAnalyticsIncluded";
    ValidateAnalyticsIncluded.options = {};
    return ValidateAnalyticsIncluded;
}(coveo_search_ui_1.Component));
exports.ValidateAnalyticsIncluded = ValidateAnalyticsIncluded;
coveo_search_ui_1.Initialization.registerAutoCreateComponent(ValidateAnalyticsIncluded);


/***/ })

}]);
//# sourceMappingURL=ValidateAnalyticsIncluded.js.map